<?php

/**
 * Mesas.class [ MODEL ADMIN ]
 * Respnsável por gerenciar as mesas no Admin do sistema!
 * 
 * @copyright (c) 2023, Edgar C. Magalhães
 */
class Mesas
{

    private $Data;
    private $Post;
    private $Error;
    private $Result;

    //Nome da tabela no banco de dados
    const Entity = DB_MESAS;

    /**
     * <b>Cadastrar o Post:</b> Envelope os dados do post em um array atribuitivo e execute esse método
     * para cadastrar o post. Envia a capa automaticamente!
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeCreate(array $Data)
    {
        $this->Data = $Data;

        if (in_array('', $this->Data)) :
            $this->Error = ["Erro ao cadastrar: Para criar um post, favor preencha todos os campos!", WS_ALERT];
            $this->Result = false;
        else :
            $this->setData();
            $this->setName();

            if ($this->Data['post_cover']) :
                $uplaod = new Upload;
                $uplaod->Image($this->Data['post_cover'], $this->Data['post_name']);
            endif;

            if (isset($uplaod) && $uplaod->getResult()) :
                $this->Data['post_cover'] = $uplaod->getResult();
                $this->Create();
            else :
                $this->Data['post_cover'] = null;
                $this->Create();
            endif;
        endif;
    }

    /**
     * <b>Atualizar Post:</b> Envelope os dados em uma array atribuitivo e informe o id de um 
     * post para atualiza-lo na tabela!
     * @param INT $PostId = Id do post
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeUpdate($PostId, array $Data)
    {
        $this->Post = (int) $PostId;
        $this->Data = $Data;

        if (in_array('', $this->Data)) :
            $this->Error = ["Para atualizar este post, preencha todos os campos ( Capa não precisa ser enviada! )", WS_ALERT];
            $this->Result = false;
        else :
            $this->setData();
            $this->setName();

            if (is_array($this->Data['post_cover'])) :
                $readCapa = new Read;
                $readCapa->ExeRead(self::Entity, "WHERE mesa_id = :post", "post={$this->Post}");
                $capa = '../uploads/' . $readCapa->getResult()[0]['post_cover'];
                if (file_exists($capa) && !is_dir($capa)) :
                    unlink($capa);
                endif;

                $uploadCapa = new Upload;
                $uploadCapa->Image($this->Data['post_cover'], $this->Data['post_name']);
            endif;

            if (isset($uploadCapa) && $uploadCapa->getResult()) :
                $this->Data['post_cover'] = $uploadCapa->getResult();
                $this->Update();
            else :
                unset($this->Data['post_cover']);
                $this->Update();
            endif;
        endif;
    }

    /**
     * <b>Deleta Post:</b> Informe o ID do post a ser removido para que esse método realize uma checagem de
     * pastas e galerias excluinto todos os dados nessesários!
     * @param INT $PostId = Id do post
     */
    public function ExeDelete($PostId)
    {
        $this->Post = (int) $PostId;

        $ReadPost = new Read;
        $ReadPost->ExeRead(self::Entity, "WHERE mesa_id = :post", "post={$this->Post}");

        if (!$ReadPost->getResult()) :
            $this->Error = ["O post que você tentou deletar não existe no sistema!", WS_ERROR];
            $this->Result = false;
        else :
            $PostDelete = $ReadPost->getResult()[0];
            if (file_exists('../uploads/' . $PostDelete['post_cover']) && !is_dir('../uploads/' . $PostDelete['post_cover'])) :
                unlink('../uploads/' . $PostDelete['post_cover']);
            endif;

            $readGallery = new Read;
            $readGallery->ExeRead("ws_posts_gallery", "WHERE mesa_id = :id", "id={$this->Post}");
            if ($readGallery->getResult()) :
                foreach ($readGallery->getResult() as $gbdel) :
                    if (file_exists('../uploads/' . $gbdel['gallery_image']) && !is_dir('../uploads/' . $gbdel['gallery_image'])) :
                        unlink('../uploads/' . $gbdel['gallery_image']);
                    endif;
                endforeach;
            endif;

            $deleta = new Delete;
            $deleta->ExeDelete("ws_posts_gallery", "WHERE mesa_id = :gbpost", "gbpost={$this->Post}");
            $deleta->ExeDelete(self::Entity, "WHERE mesa_id = :postid", "postid={$this->Post}");

            $this->Error = ["O post <b>{$PostDelete['post_title']}</b> foi removido com sucesso do sistema!", WS_ACCEPT];
            $this->Result = true;

        endif;
    }

    /**
     * <b>Ativa/Inativa Post:</b> Informe o ID do post e o status e um status sendo 1 para ativo e 0 para
     * rascunho. Esse méto ativa e inativa os posts!
     * @param INT $PostId = Id do post
     * @param STRING $PostStatus = 1 para ativo, 0 para inativo
     */
    public function ExeStatus($PostId, $Garcom, $PostStatus, $Token)
    {
        $this->Post = (int) $PostId;
        $this->Data['id_garcom'] = (int) $Garcom;
        $this->Data['situacao'] = (int) $PostStatus;
        $this->Data['token'] = (string) $Token;
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE mesa_id = :id", "id={$this->Post}");
    }

    public function ExeTransferencia($PostId, $Garcom, $PostStatus, $Token)
    {
        $this->Post = (int) $PostId;
        $this->Data['id_garcom'] = (int) $Garcom;
        $this->Data['situacao'] = (int) $PostStatus;
        $this->Data['token'] = (string) $Token;
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE mesa_id = :id", "id={$this->Post}");
    }

    public function ExeStatusMesa($PostId, $Garcom, $Situacao, $TokenLimpo, $Token)
    {
        //$postUpdate->ExeStatusMesa($dado['mesa_id'], '', 0, '', $token);
        $this->Post = (int) $PostId;
        $this->Data['id_garcom'] = (string) $Garcom;
        $this->Data['situacao'] = (int) $Situacao;
        $this->Data['token'] = (string) $TokenLimpo;
        $Token = (string) $Token;
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE mesa_id = :id AND token = '{$Token}'", "id={$this->Post}");
    }

    public function ExeInserir($PostId, $Cod, $Nome, $Preco, $Situacao, $Token, $Garcom, $Destino)
    {
        $this->Post = (int) $PostId;
        $this->Data['cod'] = (int) $Cod;
        $this->Data['destino'] = (int) $Destino;
        $this->Data['nome'] = (string) $Nome;
        $this->Data['preco'] = (float) $Preco;
        $this->Data['id_garcom'] = (int) $Garcom;
        $this->Data['situacao'] = (int) $Situacao;
        $this->Data['token'] = (string) $Token;
        $Update = new Update;
        $Update->ExeCreate(self::Entity, $this->Data, "WHERE mesa_id = :id", "id={$this->Post}");
    }

    /**
     * <b>Verificar Cadastro:</b> Retorna ID do registro se o cadastro for efetuado ou FALSE se não.
     * Para verificar erros execute um getError();
     * @return BOOL $Var = InsertID or False
     */
    public function getResult()
    {
        return $this->Result;
    }

    /**
     * <b>Obter Erro:</b> Retorna um array associativo com uma mensagem e o tipo de erro.
     * @return ARRAY $Error = Array associatico com o erro
     */
    public function getError()
    {
        return $this->Error;
    }

    /*
     * ***************************************
     * **********  PRIVATE METHODS  **********
     * ***************************************
     */

    //Valida e cria os dados para realizar o cadastro
    private function setData()
    {
        $this->Data = array_map('strip_tags', $this->Data);
        $this->Data = array_map('trim', $this->Data);
    }

    //Verifica o NAME post. Se existir adiciona um pós-fix -Count
    private function setName()
    {
        $Where = (isset($this->Post) ? "mesa_id != {$this->Post} AND" : '');
        $readName = new Read;
        $readName->ExeRead(self::Entity, "WHERE {$Where} post_title = :t", "t={$this->Data['post_title']}");
        if ($readName->getResult()) :
            $this->Data['post_name'] = $this->Data['post_name'] . '-' . $readName->getRowCount();
        endif;
    }

    //Cadastra o post no banco!
    private function Create()
    {
        $cadastra = new Create;
        $cadastra->ExeCreate(self::Entity, $this->Data);
        if ($cadastra->getResult()) :
            $this->Error = ["Registro salvo com sucesso!", WS_ACCEPT];
            $this->Result = $cadastra->getResult();
        endif;
    }

    //Atualiza o post no banco!
    private function Update()
    {
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE mesa_id = :id", "id={$this->Post}");
        if ($Update->getResult()) :
            $this->Error = ["Registro atualizado com sucesso!", WS_ACCEPT];
            $this->Result = true;
        endif;
    }
}
