<?php
ob_start();
session_start();
require('../_app/Config.inc.php');

$login = new Login(1);
$logoff = filter_input(INPUT_GET, 'logoff', FILTER_VALIDATE_BOOLEAN);
$getexe = filter_input(INPUT_GET, 'exe', FILTER_DEFAULT);

if (!$login->CheckLogin()):
    unset($_SESSION['userlogin']);
    header('Location: index.php?exe=restrito');
else:
    $userlogin = $_SESSION['userlogin'];
endif;

if ($logoff):
    unset($_SESSION['userlogin']);
    header('Location: index.php?exe=logoff');
endif;
?>
<!doctype html>
<html lang="pt-br" data-bs-theme="auto">

<head>
    <meta http-equiv="refresh" content="60" />
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Churrasqueira</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@docsearch/css@3">

    <style>
        @media (min-width: 768px) {
            .bd-placeholder-img-lg {
                font-size: 3.5rem;
            }
        }

        .b-example-divider {
            width: 100%;
            height: 3rem;
            background-color: rgba(0, 0, 0, .1);
            border: solid rgba(0, 0, 0, .15);
            border-width: 1px 0;
            box-shadow: inset 0 .5em 1.5em rgba(0, 0, 0, .1), inset 0 .125em .5em rgba(0, 0, 0, .15);
        }

        .b-example-vr {
            flex-shrink: 0;
            width: 1.5rem;
            height: 100vh;
        }

        .bi {
            vertical-align: -.125em;
            fill: currentColor;
        }

        .btn-bd-primary {
            --bd-violet-bg: #712cf9;
            --bd-violet-rgb: 112.520718, 44.062154, 249.437846;

            --bs-btn-font-weight: 600;
            --bs-btn-color: var(--bs-white);
            --bs-btn-bg: var(--bd-violet-bg);
            --bs-btn-border-color: var(--bd-violet-bg);
            --bs-btn-hover-color: var(--bs-white);
            --bs-btn-hover-bg: #6528e0;
            --bs-btn-hover-border-color: #6528e0;
            --bs-btn-focus-shadow-rgb: var(--bd-violet-rgb);
            --bs-btn-active-color: var(--bs-btn-hover-color);
            --bs-btn-active-bg: #5a23c8;
            --bs-btn-active-border-color: #5a23c8;
        }

        .bd-mode-toggle {
            z-index: 1500;
        }

        .bd-mode-toggle .dropdown-menu .active .bi {
            display: block !important;
        }
    </style>
</head>

<body>
    <div class="container py-3">
        <?php
        $action = filter_input(INPUT_GET, 'action', FILTER_DEFAULT);
        if ($action):
            require('../_models/Mesas.class.php');

            $idProduto = filter_input(INPUT_GET, 'itemid', FILTER_VALIDATE_INT);
            $postUpdate = new Mesas;

            switch ($action):
                case 'preparar':
                    // Create connection
                    $conn = new mysqli(HOST, USER, PASS, DBSA);
                    // Check connection
                    if ($conn->connect_error) {
                        die("Connection failed: " . $conn->connect_error);
                    }

                    // Agora atualizamos todos os itens da mesa que estão com status 0
                    $sql = "UPDATE " . DB_CARRINHO . " SET status = 1 WHERE mesa_id={$idProduto} AND status = 0 AND destino = 2";

                    if ($conn->query($sql) === TRUE) {
                        echo "Todos os pedidos da mesa estão em preparo";
                    } else {
                        echo "Erro ao atualizar: " . $conn->error;
                    }

                    $conn->close();
                    break;

                case 'finalizado':
                    // Create connection
                    $conn = new mysqli(HOST, USER, PASS, DBSA);
                    // Check connection
                    if ($conn->connect_error) {
                        die("Connection failed: " . $conn->connect_error);
                    }

                    // Atualiza todos os itens da mesa que estão em preparo
                    $sql = "UPDATE " . DB_CARRINHO . " SET status = 2 WHERE mesa_id={$idProduto} AND status = 1 AND destino = 2";

                    if ($conn->query($sql) === TRUE) {
                        echo "Todos os pedidos da mesa foram finalizados!";
                    } else {
                        echo "Erro ao atualizar: " . $conn->error;
                    }

                    $conn->close();
                    break;

                default:
                    WSErro("Ação não foi identifica pelo sistema!", WS_ALERT);
            endswitch;
        endif;
        ?>
        <main>
            <center>
                <h1>CHURRASQUEIRA</h1>
            </center>
            <div class="row row-cols-1 row-cols-md-3 mb-3 text-center">
                <?php
                // Primeiro vamos mostrar os pedidos novos agrupados por mesa
                $pedidos = new Read;
                $pedidos->ExeRead(DB_CARRINHO, " WHERE destino = 2 AND status = 0 GROUP BY mesa_id ORDER BY info DESC");

                foreach ($pedidos->getResult() as $mesa):
                    // Para cada mesa, vamos buscar todos os seus pedidos novos
                    $itensMesa = new Read;
                    $itensMesa->ExeRead(DB_CARRINHO, " WHERE destino = 2 AND status = 0 AND mesa_id = {$mesa['mesa_id']} ORDER BY id ASC");
                    $resultados = $itensMesa->getResult();

                    if ($resultados):

                        $nomeGarcom = new Read;
                        $nomeGarcom->ExeRead(DB_USERS, " WHERE user_id = :id", "id={$mesa['id_garcom']}");
                        $nome = $nomeGarcom->getResult()[0]['user_name'];
                        ?>
                        <audio src="hand-bell-61097.mp3" autoplay></audio>
                        <div class="col">
                            <div class="card mb-4 rounded-3 shadow-sm border-warning">
                                <div class="card-header py-3 text-bg-warning border-warning">
                                    <h4 class="my-0 fw-normal">MESA Nº <?= $mesa['mesa_id']; ?> - <?= $nome; ?> -
                                        <?= date('d/m/Y H:i:s', strtotime($mesa['info'])); ?>
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <?php
                                    // Primeiro mostramos todos os itens
                                    foreach ($resultados as $item):
                                        ?>
                                        <div class="mb-2">
                                            <h3 class="card-title">1x <?= $item['nome']; ?></h3>
                                        </div>
                                        <?php
                                    endforeach;

                                    // Depois adicionamos um único botão para preparar todos
                                    $primeiroItem = reset($resultados); // Pega o primeiro item para referência
                                    ?>
                                    <div class="mt-3">
                                        <a href="painel.php?itemid=<?= $primeiroItem['mesa_id']; ?>&action=preparar"
                                            class="w-100 btn btn-lg btn-warning">
                                            PREPARAR TODOS OS ITENS
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                    endif;
                endforeach;

                // Agora vamos mostrar os pedidos em preparo agrupados por mesa
                $mesasPreparo = new Read;
                $mesasPreparo->ExeRead(DB_CARRINHO, " WHERE destino = 2 AND status = 1 GROUP BY mesa_id ORDER BY info DESC");

                foreach ($mesasPreparo->getResult() as $mesa):
                    // Buscar todos os itens em preparo desta mesa
                    $itensPreparo = new Read;
                    $itensPreparo->ExeRead(DB_CARRINHO, " WHERE destino = 2 AND status = 1 AND mesa_id = {$mesa['mesa_id']} ORDER BY id ASC");
                    $resultados = $itensPreparo->getResult();

                    if ($resultados):
                        $nomeGarcom = new Read;
                        $nomeGarcom->ExeRead(DB_USERS, " WHERE user_id = :id", "id={$mesa['id_garcom']}");
                        $nome = $nomeGarcom->getResult()[0]['user_name'];
                        ?>
                        <div class="col">
                            <div class="card mb-4 rounded-3 shadow-sm border-danger">
                                <div class="card-header py-3 text-bg-danger border-danger">
                                    <h4 class="my-0 fw-normal">MESA Nº <?= $mesa['mesa_id']; ?> - <?= $nome; ?> -
                                        <?= date('d/m/Y H:i:s', strtotime($mesa['info'])); ?>
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <?php
                                    foreach ($resultados as $item):
                                        ?>
                                        <div class="mb-2">
                                            <h3 class="card-title">1x <?= $item['nome']; ?></h3>
                                        </div>
                                        <?php
                                    endforeach;
                                    ?>
                                    <div class="mt-3">
                                        <a href="painel.php?itemid=<?= $mesa['mesa_id']; ?>&action=finalizado"
                                            class="w-100 btn btn-lg btn-danger">
                                            FINALIZAR TODOS OS ITENS
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                    endif;
                endforeach;
                ?>
            </div>

            <center>
                <h1>PEDIDOS FINALIZADOS</h1>
            </center>
            <div class="row row-cols-1 row-cols-md-3 mb-3 text-center">
                <?php
                $pedidos = new Read;
                // Pegando as mesas com pedidos finalizados
                $pedidos->ExeRead(DB_CARRINHO, " WHERE status = 2 AND destino = 2 AND data = NOW() + INTERVAL 1 DAY GROUP BY mesa_id ORDER BY info DESC");
                foreach ($pedidos->getResult() as $mesa):
                    // Buscando todos os itens finalizados da mesa
                    $itensMesa = new Read;
                    $itensMesa->ExeRead(DB_CARRINHO, " WHERE status = 2 AND destino = 2 AND mesa_id = {$mesa['mesa_id']} ORDER BY id DESC");
                    $nomeGarcom = new Read;
                    $nomeGarcom->ExeRead(DB_USERS, " WHERE user_id = :id", "id={$mesa['id_garcom']}");
                    $nome = $nomeGarcom->getResult()[0]['user_name'];
                    ?>
                    <div class="col">
                        <div class="card mb-4 rounded-3 shadow-sm border-primary">
                            <div class="card-header py-3 text-bg-primary border-primary">
                                <h4 class="my-0 fw-normal">MESA Nº <?= $mesa['mesa_id']; ?> - <?= $nome; ?> -
                                    <?= date('d/m/Y H:i:s', strtotime($mesa['info'])); ?>
                                </h4>
                            </div>
                            <div class="card-body">
                                <?php
                                foreach ($itensMesa->getResult() as $item):
                                    ?>
                                    <h3 class="card-title mb-2">1x <?= $item['nome']; ?></h3>
                                    <?php
                                endforeach;
                                ?>
                            </div>
                        </div>
                    </div>
                    <?php
                endforeach;
                ?>
            </div>
        </main>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz"
        crossorigin="anonymous"></script>

</body>

</html>
<?php
ob_end_flush();