<?php
$clienteUser = filter_input(INPUT_GET, 'clientid', FILTER_VALIDATE_INT);

$clientes = new Read;
$clientes->ExeRead(DB_CLIENTES, "WHERE cliente_id = :id", "id={$clienteUser}");
$cliente = $clientes->getResult()[0];

$pedidos = new Read;
$pedidos->FullRead("SELECT * FROM " . DB_CARRINHO . " WHERE delivery_cliente = :id GROUP BY token ORDER BY data DESC ", "id={$clienteUser}");
$pedido = $pedidos->getRowCount();
?>

<div class="min-h-[calc(100vh-152px)]">
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Compras - <?= $pedido; ?></h2>
    <div class="grid grid-cols-1 gap-6">
        <div x-data="basic" class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <h5 class="mb-6 text-base font-medium text-slate-600 dark:text-indigo-300">Compras do cliente -
                <?= $cliente['cliente_nome']; ?>
            </h5>
            <div class>
                <table id="myTable" class="whitespace-nowrap table-hover table-bordered"></table>
            </div>
        </div>
    </div>
</div>

<?php
// Monta os dados no PHP

$rows = [];
if (!empty($clientes->getResult())) {
    foreach ($clientes->getResult() as $c) {

        $pedidos = new Read;
        $pedidos->FullRead("SELECT DISTINCT *, SUM(preco) AS Preco FROM " . DB_CARRINHO . " WHERE delivery_cliente = :id GROUP BY token ORDER BY data DESC ", "id={$clienteUser}");
        $pedido = $pedidos->getRowCount();
        $p = $pedidos->getResult()[0];

        // Ajusta os campos conforme sua tabela
        $id = $p['token'];
        $dataCompra = date('d/m/Y', strtotime($p['data']));
        $valor = number_format($p['Preco'], 2, ',', '.');

        // Você pode montar os links como quiser
        $acoes = '<a href="'.HOME.'/system/delivery/imprimir.php?cliente=' . $clienteUser . '&token=' . $id . '" target="_blank">Ver</a> | <a href="painel.php?exe=delivery/index_client&client=' . $id . '&action=delete" onclick="return confirm(\'Confirmar exclusão?\')">Deletar</a>';

        $rows[] = [$id, $dataCompra, $valor, $acoes];
    }
}
?>
<script>
    document.addEventListener("alpine:init", () => {
        Alpine.data('basic', () => ({
            datatable: null,
            init() {
                this.datatable = new simpleDatatables.DataTable('#myTable', {
                    data: {
                        headings: ['Token', 'Data', 'Valor', 'Ações'],
                        // PHP injeta um JSON VÁLIDO aqui
                        data: <?php echo json_encode($rows, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES); ?>,
                    },
                    sortable: false,
                    searchable: true,
                    perPage: 20,
                    perPageSelect: [5, 10, 20, 50, 100],
                    firstLast: false,
                    firstText:
                        '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="https://www.w3.org/2000/svg" class="w-4.5 h-4.5"> <path d="M13 19L7 12L13 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.5" d="M16.9998 19L10.9998 12L16.9998 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                    lastText:
                        '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="https://www.w3.org/2000/svg" class="w-4.5 h-4.5"> <path d="M11 19L17 12L11 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.5" d="M6.99976 19L12.9998 12L6.99976 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                    prevText:
                        '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="https://www.w3.org/2000/svg" class="w-4.5 h-4.5"> <path d="M15 5L9 12L15 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                    nextText:
                        '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="https://www.w3.org/2000/svg" class="w-4.5 h-4.5"> <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                    labels: { perPage: '{select}' },
                    layout: { top: '{select}{search}', bottom: '{info}{pager}' },

                    // Se os links em "Ações" não clicarem, ativa render sem sanitização:
                    columns: [{ select: 6, render: (data) => data }],
                });
            },
        }));
    });
</script>