<div class="min-h-[calc(100vh-152px)]">
    <?php
    $ClienteData = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    if ($ClienteData && $ClienteData['SendPostForm']) :
        unset($ClienteData['SendPostForm']);

        require('_models/AdminUser.class.php');
        $cadastra = new AdminUser;
        $cadastra->ExeCreate($ClienteData);

        if ($cadastra->getResult()) :
            header("Location: painel.php?exe=users/update&create=true&userid={$cadastra->getResult()}");
        else :
            WSErro($cadastra->getError()[0], $cadastra->getError()[1]);
        endif;
    endif;
    ?>
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Usuário</h2>
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <h5 class="mb-6 text-base font-medium text-slate-600 dark:text-indigo-300">Cadastrar usuário</h5>
            <form action="" method="post" name="UserCreateForm">
                <div class="grid grid-cols-3 gap-5">
                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Nome</label>
                        <input type="text" class="form-input" placeholder="Informe o nome" name="user_name" value="<?php if (!empty($ClienteData['user_name'])) echo $ClienteData['user_name']; ?>" autofocus>
                    </div>

                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Sobrenome</label>
                        <input type="text" class="form-input" placeholder="Informe o sobrenome" name="user_lastname" value="<?php if (!empty($ClienteData['user_lastname'])) echo $ClienteData['user_lastname']; ?>">
                    </div>

                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">E-mail</label>
                        <input type="email" class="form-input" placeholder="Informe o e-mail" name="user_email" value="<?php if (!empty($ClienteData['user_email'])) echo $ClienteData['user_email']; ?>">
                    </div>

                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Usuário</label>
                        <input type="text" class="form-input" placeholder="Informe o usuário" name="user_user" value="<?php if (!empty($ClienteData['user_user'])) echo $ClienteData['user_user']; ?>">
                    </div>

                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Senha</label>
                        <input type="password" class="form-input" placeholder="Informe a senha" name="user_password" value="<?php if (!empty($ClienteData['user_password'])) echo $ClienteData['user_password']; ?>">
                    </div>
                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Categoria</label>
                        <select name="user_level" title="Selecione o nível de usuário" class="form-select">
                            <option value="">Selecione o Nível</option>
                            <option value="1" <?php if (isset($ClienteData['user_level']) && $ClienteData['user_level'] == 1) echo 'selected="selected"'; ?>>Garçom/Cozinha</option>
                            <option value="2" <?php if (isset($ClienteData['user_level']) && $ClienteData['user_level'] == 2) echo 'selected="selected"'; ?>>Gerente</option>
                            <option value="3" <?php if (isset($ClienteData['user_level']) && $ClienteData['user_level'] == 3) echo 'selected="selected"'; ?>>Admin</option>
                        </select>
                    </div>
                </div>
                <div>
                    <br />
                    <input type="submit" name="SendPostForm" value="Cadastrar" class="btn border-indigo-600 bg-indigo-600 text-white hover:border-indigo-700 dark:disabled:bg-white/10 dark:disabled:border-white/10 disabled:bg-gray-300 disabled:border-gray-300 hover:bg-indigo-700" />
                </div>
            </form>
        </div>
    </div>
</div>