<!doctype html>
<html lang="pt-br" data-bs-theme="auto">

<head>
    <script src="/docs/5.3/assets/js/color-modes.js"></script>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Adicionais</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-9ndCyUaIbzAi2FUVXJi0CjmCapSmO7SnpJef0486qhLnuZ2cdeRhO02iuK6FUUVM" crossorigin="anonymous">

    <style>
        .bd-placeholder-img {
            font-size: 1.125rem;
            text-anchor: middle;
            -webkit-user-select: none;
            -moz-user-select: none;
            user-select: none;
        }

        @media (min-width: 768px) {
            .bd-placeholder-img-lg {
                font-size: 3.5rem;
            }
        }

        .b-example-divider {
            width: 100%;
            height: 3rem;
            background-color: rgba(0, 0, 0, .1);
            border: solid rgba(0, 0, 0, .15);
            border-width: 1px 0;
            box-shadow: inset 0 .5em 1.5em rgba(0, 0, 0, .1), inset 0 .125em .5em rgba(0, 0, 0, .15);
        }

        .b-example-vr {
            flex-shrink: 0;
            width: 1.5rem;
            height: 100vh;
        }

        .bi {
            vertical-align: -.125em;
            fill: currentColor;
        }

        .nav-scroller {
            position: relative;
            z-index: 2;
            height: 2.75rem;
            overflow-y: hidden;
        }

        .nav-scroller .nav {
            display: flex;
            flex-wrap: nowrap;
            padding-bottom: 1rem;
            margin-top: -1px;
            overflow-x: auto;
            text-align: center;
            white-space: nowrap;
            -webkit-overflow-scrolling: touch;
        }

        .btn-bd-primary {
            --bd-violet-bg: #712cf9;
            --bd-violet-rgb: 112.520718, 44.062154, 249.437846;

            --bs-btn-font-weight: 600;
            --bs-btn-color: var(--bs-white);
            --bs-btn-bg: var(--bd-violet-bg);
            --bs-btn-border-color: var(--bd-violet-bg);
            --bs-btn-hover-color: var(--bs-white);
            --bs-btn-hover-bg: #6528e0;
            --bs-btn-hover-border-color: #6528e0;
            --bs-btn-focus-shadow-rgb: var(--bd-violet-rgb);
            --bs-btn-active-color: var(--bs-btn-hover-color);
            --bs-btn-active-bg: #5a23c8;
            --bs-btn-active-border-color: #5a23c8;
        }

        .bd-mode-toggle {
            z-index: 1500;
        }

        html,
        body {
            height: 100%;
        }

        .form-signin {
            max-width: 630px;
            padding: 1rem;
        }

        .form-signin .form-floating:focus-within {
            z-index: 2;
        }

        .form-signin input[type="email"] {
            margin-bottom: -1px;
            border-bottom-right-radius: 0;
            border-bottom-left-radius: 0;
        }

        .form-signin input[type="password"] {
            margin-bottom: 10px;
            border-top-left-radius: 0;
            border-top-right-radius: 0;
        }
    </style>
</head>

<body class="d-flex align-items-center py-4 bg-body-tertiary">
    <main class="form-signin w-100 m-auto">
        <?php
        require('../../../_app/Config.inc.php');
        $mesa_id = filter_input(INPUT_GET, 'mesa_id');
        $token = filter_input(INPUT_GET, 'token', FILTER_DEFAULT);
        $id_garcom = filter_input(INPUT_GET, 'id_garcom', FILTER_DEFAULT);
        $produto_cod = filter_input(INPUT_GET, 'produto', FILTER_VALIDATE_INT);

        $post = filter_input_array(INPUT_POST, FILTER_DEFAULT);
        if (isset($post) && $post['SendPostForm']):
            unset($post['SendPostForm']);

            require('../../_models/Parciais.class.php');
            $cadastra = new Parciais;
            $cadastra->ExeCreate($post);

            if ($cadastra->getResult()):
                echo "<script>
		alert('Pagamento parcial registrado com sucesso!')
		window.close();
		window.opener.location.href = 'https://botecodozehenrique.edgarmagalhaes.com/vendas/system/restaurante/adicional.php?token=<?=$token;?>&produto=<?=$produto_cod;?>';
		</script>";
            endif;
        endif;

        $action = filter_input(INPUT_GET, 'action', FILTER_DEFAULT);
        if ($action):
            require('../../../_models/Mesas.class.php');

            $postAction = filter_input(INPUT_GET, 'mesa', FILTER_VALIDATE_INT);
            $fecharMesa = filter_input(INPUT_GET, 'mesa_id', FILTER_VALIDATE_INT);
            $itemDeletar = filter_input(INPUT_GET, 'itemid', FILTER_VALIDATE_INT);

            $cod = filter_input(INPUT_GET, 'cod');
            $nome = filter_input(INPUT_GET, 'nome');
            $preco = filter_input(INPUT_GET, 'preco');
            $id_garcom = filter_input(INPUT_GET, 'id_garcom');
            $destino = filter_input(INPUT_GET, 'destino');
            $data = date('Y-m-d');
            $time = date("H:i:s");

            //https://botecodozehenrique.edgarmagalhaes.com/system/restaurante/adicional.php?action=inserir&cod=292&nome=BATATA&preco=7&qtd=1&token=8dba303f4e6403de&id_garcom=1&destino=1&id_categoria=35
        
            $postUpdate = new Mesas;

            switch ($action):
                case 'inserir':
                    // Create connection
                    $conn = new mysqli(HOST, USER, PASS, DBSA);
                    // Check connection
                    if ($conn->connect_error) {
                        die("Connection failed: " . $conn->connect_error);
                    }

                    $sql = "UPDATE " . DB_CARRINHO . " SET familia = 1 WHERE cod = {$produto_cod} AND token = '{$token}'";

                    if ($conn->query($sql) === TRUE) {
                        echo "";
                    } else {
                        echo "Error updating record: " . $conn->error;
                    }

                    $couvertCreate = ['cod' => $cod, "nome" => $nome, "preco" => $preco, "mesa_id" => $mesa_id, "qtd" => 1, "situacao" => 1, "time" => $time, "data" => $data, "id_garcom" => $id_garcom, "token" => $token, "destino" => $destino, "produto_add" => 1, "produto_cod" => $produto_cod];
                    $insertCouvert = new Create;
                    $insertCouvert->ExeCreate(DB_CARRINHO, $couvertCreate);

                    WSErro("Produto adicionado com sucesso!", WS_ACCEPT);
                    break;
                default:
                    WSErro("Ação não foi identifica pelo sistema, favor utilize os botões!", WS_ALERT);
            endswitch;
        endif;
        ?>

        <h1 class="h3 mb-3 fw-normal">Adicionais</h1>

        <?php
        $produtos = new Read;
        $produtos->ExeRead(DB_PRODUTOS, " WHERE id_categoria = 9 OR id_categoria = 10 ");
        foreach ($produtos->getResult() as $produto):
            extract($produto);
            ?>
            <li><a href="<?= HOME; ?>/vendas/system/restaurante/adicional.php?action=inserir&cod=<?= $cod; ?>&produto=<?= $produto_cod; ?>&mesa_id=<?= $mesa_id; ?>&nome=<?= $nome; ?>&preco=<?= $preco; ?>&qtd=1&token=<?= $token; ?>&id_garcom=<?= $id_garcom; ?>&destino=<?= $destino; ?>&id_categoria=35"
                    class="btn"><?= $nome; ?></a></li>
            <?php
        endforeach;
        ?>
    </main>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-geWF76RCwLtnZ8qwWowPQNguL3RmwHVBC9FhGdlKrxdiJJigb/j/68SIy3Te4Bkz"
        crossorigin="anonymous"></script>

</body>

</html>