<?php
$action = filter_input(INPUT_GET, 'action', FILTER_DEFAULT);
if ($action):
    require('_models/Clients.class.php');

    $postAction = filter_input(INPUT_GET, 'client', FILTER_VALIDATE_INT);
    $postUpdate = new Clients;

    switch ($action):
        case 'delete':
            $postUpdate->ExeDelete($postAction);
            WSErro($postUpdate->getError()[0], $postUpdate->getError()[1]);
            break;

        default:
            WSErro("Ação não foi identifica pelo sistema, favor utilize os botões!", WS_ALERT);
    endswitch;
endif;
?>
<div class="min-h-[calc(100vh-152px)]">
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Clientes</h2>
    <div class="grid grid-cols-1 gap-6">
        <div x-data="basic" class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <h5 class="mb-6 text-base font-medium text-slate-600 dark:text-indigo-300">Clientes cadastrados</h5>
            <div class>
                <table id="myTable" class="whitespace-nowrap table-hover table-bordered"></table>
            </div>
        </div>
    </div>
</div>

<?php
// Monta os dados no PHP
$clientes = new Read;
$clientes->ExeRead(DB_CLIENTES);

$rows = [];
if (!empty($clientes->getResult())) {
    foreach ($clientes->getResult() as $c) {
        // Ajusta os campos conforme sua tabela
        $id = (int) ($c['cliente_id']);
        $nome = "<a href='painel.php?exe=delivery/view_client&clientid={$id}'>" . $c['cliente_nome'] . "</a>";
        $telefone = $c['cliente_telefone'];
        $cliente_desde = date('d/m/Y', strtotime($c['cliente_cadastro']));
        $nascimento = date('d/m/Y', strtotime($c['cliente_nascimento']));

        // Você pode montar os links como quiser
        $acoes = '<a href="painel.php?exe=delivery/create_delivery_client&clientid=' . $id . '&token=' . getRandomStringMd5() . '">Vender</a> | <a href="painel.php?exe=delivery/update_client&clientid=' . $id . '">Editar</a> | <a href="painel.php?exe=delivery/index_client&client=' . $id . '&action=delete" onclick="return confirm(\'Confirmar exclusão?\')">Deletar</a>';

        $rows[] = [$id, $nome, $telefone, $cliente_desde, $nascimento, $acoes];
    }
}
?>

<script>
    document.addEventListener("alpine:init", () => {
        Alpine.data('basic', () => ({
            datatable: null,
            init() {
                this.datatable = new simpleDatatables.DataTable('#myTable', {
                    data: {
                        headings: ['ID', 'Nome', 'Telefone', 'Cliente desde', 'Data nascimento', 'Ações'],
                        // PHP injeta um JSON VÁLIDO aqui
                        data: <?php echo json_encode($rows, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES); ?>,
                    },
                    sortable: false,
                    searchable: true,
                    perPage: 20,
                    perPageSelect: [5, 10, 20, 50, 100],
                    firstLast: false,
                    firstText:
                        '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="https://www.w3.org/2000/svg" class="w-4.5 h-4.5"> <path d="M13 19L7 12L13 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.5" d="M16.9998 19L10.9998 12L16.9998 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                    lastText:
                        '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="https://www.w3.org/2000/svg" class="w-4.5 h-4.5"> <path d="M11 19L17 12L11 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.5" d="M6.99976 19L12.9998 12L6.99976 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                    prevText:
                        '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="https://www.w3.org/2000/svg" class="w-4.5 h-4.5"> <path d="M15 5L9 12L15 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                    nextText:
                        '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="https://www.w3.org/2000/svg" class="w-4.5 h-4.5"> <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                    labels: { perPage: '{select}' },
                    layout: { top: '{select}{search}', bottom: '{info}{pager}' },

                    // Se os links em "Ações" não clicarem, ativa render sem sanitização:
                    columns: [{ select: 6, render: (data) => data }],
                });
            },
        }));
    });
</script>