<!-- Adicionando JQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"
    integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>

<!-- Adicionando Javascript -->
<script>

    $(document).ready(function () {

        function limpa_formulário_cep() {
            // Limpa valores do formulário de cep.
            $("#rua").val("");
            $("#bairro").val("");
            $("#cidade").val("");
            $("#uf").val("");
            $("#ibge").val("");
        }

        //Quando o campo cep perde o foco.
        $("#cep").blur(function () {

            //Nova variável "cep" somente com dígitos.
            var cep = $(this).val().replace(/\D/g, '');

            //Verifica se campo cep possui valor informado.
            if (cep != "") {

                //Expressão regular para validar o CEP.
                var validacep = /^[0-9]{8}$/;

                //Valida o formato do CEP.
                if (validacep.test(cep)) {

                    //Preenche os campos com "..." enquanto consulta webservice.
                    $("#rua").val("...");
                    $("#bairro").val("...");
                    $("#cidade").val("...");
                    $("#uf").val("...");
                    $("#ibge").val("...");

                    //Consulta o webservice viacep.com.br/
                    $.getJSON("https://viacep.com.br/ws/" + cep + "/json/?callback=?", function (dados) {

                        if (!("erro" in dados)) {
                            //Atualiza os campos com os valores da consulta.
                            $("#rua").val(dados.logradouro);
                            $("#bairro").val(dados.bairro);
                            $("#cidade").val(dados.localidade);
                            $("#uf").val(dados.uf);
                            $("#ibge").val(dados.ibge);
                        } //end if.
                        else {
                            //CEP pesquisado não foi encontrado.
                            limpa_formulário_cep();
                            alert("CEP não encontrado.");
                        }
                    });
                } //end if.
                else {
                    //cep é inválido.
                    limpa_formulário_cep();
                    alert("Formato de CEP inválido.");
                }
            } //end if.
            else {
                //cep sem valor, limpa formulário.
                limpa_formulário_cep();
            }
        });
    });

</script>

<div class="min-h-[calc(100vh-152px)]">
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Clientes</h2>
    <?php
    $post = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    $postid = filter_input(INPUT_GET, 'clientid', FILTER_VALIDATE_INT);

    if (isset($post) && $post['SendPostForm']):
        unset($post['SendPostForm']);

        require('_models/Clients.class.php');
        $cadastra = new Clients;
        $cadastra->ExeUpdate($postid, $post);

        WSErro($cadastra->getError()[0], $cadastra->getError()[1]);
    else:
        $read = new Read;
        $read->ExeRead(DB_CLIENTES, "WHERE cliente_id = :id", "id={$postid}");
        if (!$read->getResult()):
            header('Location: painel.php?exe=delivery/index_client&empty=true');
        else:
            $post = $read->getResult()[0];
        endif;
    endif;

    $checkCreate = filter_input(INPUT_GET, 'create', FILTER_VALIDATE_BOOLEAN);
    if ($checkCreate && empty($cadastra)):
        WSErro("O cliente foi cadastrado com sucesso!", WS_ACCEPT);
    endif;
    ?>
    <br />
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <h5 class="mb-6 text-base font-medium text-slate-600 dark:text-indigo-300">Atualizar cliente</h5>
            <form name="PostForm" action="" method="post" enctype="multipart/form-data">
                <div class="grid grid-cols-3 gap-5">
                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Nome
                            do cliente</label>
                        <input type="text" class="form-input" name="cliente_nome"
                            placeholder="Informe o nome do cliente" value="<?php if (isset($post['cliente_nome']))
                                echo $post['cliente_nome']; ?>" autofocus>
                    </div>

                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Data
                            de nascimento</label>
                        <input type="date" class="form-input" name="cliente_nascimento"
                            placeholder="Informe a data de nascimento do cliente" value="<?php
                            if (isset($post['cliente_nascimento'])):
                                echo $post['cliente_nascimento'];
                            else:
                                echo date('d/m/Y');
                            endif;
                            ?>">
                    </div>

                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Telefone</label>
                        <input type="text" class="form-input" name="cliente_telefone"
                            placeholder="Informe o telefone do cliente" value="<?php if (isset($post['cliente_telefone']))
                                echo $post['cliente_telefone']; ?>" data-mask="(00) 00000-0000">
                    </div>

                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">CEP</label>
                        <input type="text" class="form-input" name="cliente_cep" placeholder="Informe o CEP do cliente"
                            value="<?php if (isset($post['cliente_cep']))
                                echo $post['cliente_cep']; ?>" id="cep" data-mask="00.000-000">
                    </div>

                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Número</label>
                        <input type="text" class="form-input" name="cliente_numero"
                            placeholder="Informe o número do cliente" value="<?php if (isset($post['cliente_numero']))
                                echo $post['cliente_numero']; ?>">
                    </div>

                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Complemento</label>
                        <input type="text" class="form-input" name="cliente_complemento"
                            placeholder="Informe o complemento do cliente" value="<?php if (isset($post['cliente_complemento']))
                                echo $post['cliente_complemento']; ?>">
                    </div>

                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Rua</label>
                        <input type="text" class="form-input" name="cliente_rua" placeholder="Informe a rua do cliente"
                            value="<?php if (isset($post['cliente_rua']))
                                echo $post['cliente_rua']; ?>" id="rua">
                    </div>

                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Bairro</label>
                        <input type="text" class="form-input" name="cliente_bairro"
                            placeholder="Informe o bairro do cliente" value="<?php if (isset($post['cliente_bairro']))
                                echo $post['cliente_bairro']; ?>" id="bairro">
                    </div>

                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Cidade</label>
                        <input type="text" class="form-input" name="cliente_cidade"
                            placeholder="Informe a cidade do cliente" value="<?php if (isset($post['cliente_cidade']))
                                echo $post['cliente_cidade']; ?>" id="cidade">
                    </div>

                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Estado</label>
                        <input type="text" class="form-input" name="cliente_estado"
                            placeholder="Informe o estado do cliente" value="<?php if (isset($post['cliente_estado']))
                                echo $post['cliente_estado']; ?>" id="uf">
                    </div>
                </div>
                <div>
                    <br />
                    <input type="submit"
                        class="btn border-indigo-600 bg-indigo-600 text-white hover:border-indigo-700 dark:disabled:bg-white/10 dark:disabled:border-white/10 disabled:bg-gray-300 disabled:border-gray-300 hover:bg-indigo-700"
                        value="Atualizar" name="SendPostForm" />
                </div>
            </form>
        </div>
    </div>
</div>