<div class="min-h-[calc(100vh-152px)]">
    <?php
    $empty = filter_input(INPUT_GET, 'empty', FILTER_VALIDATE_BOOLEAN);
    if ($empty):
        WSErro("Ops: Você tentou editar um produto que não existe!", WS_INFOR);
    endif;

    $action = filter_input(INPUT_GET, 'action', FILTER_DEFAULT);
    if ($action):
        require('_models/Alimentos.php');

        $postAction = filter_input(INPUT_GET, 'estoque_id', FILTER_VALIDATE_INT);
        $postUpdate = new Alimentos;

        switch ($action):
            case 'delete':
                $postUpdate->ExeDelete($postAction);
                WSErro($postUpdate->getError()[0], $postUpdate->getError()[1]);
                break;

            default:
                WSErro("Ação não foi identifica pelo sistema, favor utilize os botões!", WS_ALERT);
        endswitch;
    endif;
    ?>  

    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Estoque alimentos</h2>

    <?php
    $checkCreate = filter_input(INPUT_GET, 'create', FILTER_VALIDATE_BOOLEAN);
    if ($checkCreate && empty($cadastra)):
        WSErro("O produto foi cadastrado com sucesso!", WS_ACCEPT);
    endif;
    ?>
    <br/>
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <div class="table-responsive">
                <table class="table-hover">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Quantidade</th>
                            <th>Unidade</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $estoques = new Read;
                        $estoques->ExeRead(DB_ALIMENTOS, " ORDER BY estoque_id ASC");
                        foreach ($estoques->getResult() as $estoque):
                            extract($estoque);
                            ?>
                            <tr>
                                <td class="whitespace-nowrap"><?= $estoque_nome; ?></td>
                                <td><?=$estoque_qtd;?> </td>
                                <td><?= $estoque_und; ?></td>
                                <td class="text-center">
                                    <!--<a
                                        href="painel.php?exe=produtos/entrada&produtoid=<?= $cod; ?>">Lançar estoque</a> |-->
                                    <a href="painel.php?exe=estoque/update_item&estoqueid=<?= $estoque_id; ?>">Editar</a> | <a
                                        href="painel.php?exe=estoque/index_item&estoque_id=<?= $estoque_id; ?>&action=delete"
                                        onclick="return confirm('Tem certeza de que quer deletar este item?');">Excluir</a>
                                </td>
                            </tr>
                            <?php
                        endforeach;
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>